#pragma once


/*
DeviceIoControl API:
WINBASEAPI BOOL WINAPI DeviceIoControl (HANDLE hDevice, DWORD dwIoControlCode, __inout_bcount_opt(nInBufSize)LPVOID lpInBuf, DWORD nInBufSize, __inout_bcount_opt(nOutBufSize) LPVOID lpOutBuf, DWORD nOutBufSize, __out_opt LPDWORD lpBytesReturned, __reserved LPOVERLAPPED lpOverlapped);
-hDevice is always your handle to the BQ driver obtained with CreateFile
-dwIoControlCode is one of the IOCTL_XXX listed below
-lpInBuf: input buffer
-nInBufSize: input buffer size in bytes
-lpOutBuf: Output buffer
-nOutBufSize: output buffer size in bytes
-lpBytesReturned: pointer to integer that will contain number of bytes returned
-lpOverlapped: pointer to an overlapped structure to allow asynchronous access

*/
#define IOCTL_SETSLAVEADDR 0x1001

/*
API:
-lpInBuf: points to a byte with the slave address
-nInBufSize: 1
-lpBytesReturned: will return 1 on success, 0 otherwise
*/
#define IOCTL_I2CREAD 0x1002
/*
API:
-lpInBuf: Command Code
-nInBufSize: number of bytes in command code (should be 1) numbers other than 1 will throw error currently
-lpOutBuf: pointer to buffer
-nOutBufSize: number of bytes in buffer: will be interpreted as number of bytes to read
-lpBytesReturned: return number of bytes read
*/

#define IOCTL_I2CWRITE 0x1003

/*
API:
-lpInBuf: Write buffer: Command code followed by data to write
-nInBufSize: Write buffer size: will be interpreted as number of bytes to write (including command code).
-lpBytesReturned: Number of bytes written
*/

/*
	General Read API:
	Read DataRam with ReadFile command:
	ReadFile(HANDLE,LPBUFFER,sizeof(BUFFER),&DWBYTESWRITTEN,LPOVERLAPPED);

	the BUFFER to be sent should be of the following form, and the size should be sizeof(BQ_Data);
*/


typedef struct sBQ_Data {
	USHORT Control;
	SHORT AtRate;
	USHORT AtRateTTE;
	SHORT Temp;
	USHORT Voltage;
	USHORT Flags;
	USHORT NomAvailCap;
	USHORT FullAvailCap;
	USHORT RemCap;
	USHORT FullChgCap;
	SHORT AvgCurr;
	USHORT TTE;
	USHORT TTF;
	USHORT StbyCurr;
	USHORT StbyTTE;
	USHORT MaxLoadCurr;
	USHORT MaxLoadTTE;
	USHORT AvailEnergy;
	USHORT AvgPow;
	USHORT TTEAtConstPow;
	USHORT CycleCnt;
	USHORT StateOfChg;
} BQ_Data ;